package gov.va.med.mhv.bluebutton.web.bean;

import gov.va.med.mhv.bluebutton.web.ViewMode;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class MainViewBean implements Serializable   {
	private static final long serialVersionUID = 1L;

	private ViewMode viewMode = ViewMode.MV_SELECT_REPORT;
	
	private ViewMode selectMode = ViewMode.MV_DOWNLOAD_MY_DATA;  //defaultSelection
	
	private String previousPagePath = "";

	public ViewMode getSelectMode() {
		return selectMode;
	}

	public void setSelectMode(ViewMode selectMode) {
		this.selectMode = selectMode;
	}
	
	public String getSelectModeString() {
		return selectMode.getMode();
	}

	public void setSelectModeString(String selectMode) {
		// If we set the selection to another option we need to switch the view to correspond
		this.viewMode = ViewMode.valueOf(selectMode);
		this.selectMode = ViewMode.valueOf(selectMode);
	}

	public ViewMode getViewMode() {
		return viewMode;
	}
	
	public void setViewMode(ViewMode view) {
		viewMode = view;
	}
	
	public String getViewModeString() {
		return viewMode.getMode();
	}

	public void setViewModeString(String viewMode) {
		this.viewMode = ViewMode.valueOf(viewMode);
	}
	
	public String getPreviousPagePath() {
		return previousPagePath;
	}

	public void setPreviousPagePath(String previousPagePath) {
		this.previousPagePath = previousPagePath;
	}
}
